# Telegram Multi-Tenant Bot System

A production-ready, enterprise-grade Telegram bot system with complete activity tracking, dual key management, user monitoring, server health, broadcast messaging, payment integration, APK distribution, and recharge system.

## Features

### 👑 Owner (Super Admin)
- Manage all admins with complete configuration
- View all users across all bots (with Telegram IDs)
- View ALL admin and user activities
- Recharge system for admin subscriptions
- Global broadcast messaging
- Full system analytics and monitoring

### 🤖 Admin (Per Bot)
- Independent bot with unique identity
- View their users' Telegram IDs
- Complete user activity tracking
- Dual key management (stored + generated)
- Payment gateway integration
- APK file management
- Targeted broadcast system

### 👥 User (End User)
- No login required
- Purchase keys with multiple payment options
- Download APK files
- View their keys and expiry
- Receive broadcasts
- No admin features visible

## Quick Start

### Prerequisites
- Docker and Docker Compose
- Python 3.11+
- Node.js 18+
- PostgreSQL 14+ (included in Docker)
- Redis 7+ (included in Docker)
- RabbitMQ 3+ (included in Docker)

### Installation

1. Clone the repository:
```bash
git clone https://github.com/yourusername/telegram-multi-tenant-bot.git
cd telegram-multi-tenant-bot