# backend/api/v1/__init__.py
"""API v1 endpoints"""
from fastapi import APIRouter
from . import auth, owner, admin, user, keys, payments, broadcasts, activity, monitoring, system

router = APIRouter(prefix="/api/v1")
router.include_router(auth.router)
router.include_router(owner.router)
router.include_router(admin.router)
router.include_router(user.router)
router.include_router(keys.router)
router.include_router(payments.router)
router.include_router(broadcasts.router)
router.include_router(activity.router)
router.include_router(monitoring.router)
router.include_router(system.router)

__all__ = ['router']