# backend/bot_core/handlers/plans_handler.py
from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes
import logging

from shared.constants.messages import BotMessages
from shared.constants import DEFAULT_PRICES
from bot_core.keyboards.plans_keyboard import get_plans_keyboard

logger = logging.getLogger(__name__)

class PlansHandler:
    """Handler for /plans command"""
    
    async def handle(self, update: Update, context: ContextTypes.DEFAULT_TYPE, reserve_id: str):
        """Handle /plans command"""
        # Get plans from database (would be dynamic in production)
        plans = [
            {"duration": "1 Day", "price": DEFAULT_PRICES["1d"], "description": "Best for: Quick access"},
            {"duration": "3 Days", "price": DEFAULT_PRICES["3d"], "description": "Best for: Weekend gaming"},
            {"duration": "7 Days", "price": DEFAULT_PRICES["7d"], "description": "Best for: Weekly pass"},
            {"duration": "30 Days", "price": DEFAULT_PRICES["30d"], "description": "Best for: Monthly saving"},
            {"duration": "60 Days", "price": DEFAULT_PRICES["60d"], "description": "Best for: Best value"}
        ]
        
        # Build plans message
        plans_text = BotMessages.PLANS_HEADER
        for plan in plans:
            plans_text += BotMessages.PLAN_DETAIL.format(
                duration=plan["duration"],
                price=plan["price"],
                description=plan["description"]
            )
        
        # Get plans keyboard
        keyboard = get_plans_keyboard()
        
        await update.message.reply_text(
            plans_text,
            reply_markup=keyboard,
            parse_mode='Markdown'
        )
        
        logger.info(f"User {update.effective_user.id} viewed plans")