# backend/bot_core/handlers/start_handler.py
from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes
import logging

from shared.constants.messages import BotMessages
from bot_core.keyboards.main_menu import get_main_menu_keyboard

logger = logging.getLogger(__name__)

class StartHandler:
    """Handler for /start command"""
    
    async def handle(self, update: Update, context: ContextTypes.DEFAULT_TYPE, reserve_id: str):
        """Handle /start command"""
        user = update.effective_user
        
        # Get user's first name
        first_name = user.first_name or "User"
        
        # Customize welcome message
        welcome_text = f"👋 Hello {first_name}!\n\n" + BotMessages.WELCOME
        
        # Get main menu keyboard
        keyboard = get_main_menu_keyboard()
        
        # Send welcome message with photo (optional)
        try:
            # Try to send with photo if available
            # await update.message.reply_photo(
            #     photo=open('assets/welcome.jpg', 'rb'),
            #     caption=welcome_text,
            #     reply_markup=keyboard
            # )
            
            # Fallback to text message
            await update.message.reply_text(
                welcome_text,
                reply_markup=keyboard,
                parse_mode='Markdown'
            )
        except Exception as e:
            logger.error(f"Error sending welcome message: {e}")
            await update.message.reply_text(
                welcome_text,
                reply_markup=keyboard,
                parse_mode='Markdown'
            )
        
        logger.info(f"User {user.id} started bot {reserve_id}")