# backend/bot_core/keyboards/inline_keyboards.py
from telegram import InlineKeyboardButton, InlineKeyboardMarkup
from typing import List, Dict

def create_inline_keyboard(buttons: List[Dict[str, str]], rows: int = None):
    """Create inline keyboard from button definitions"""
    keyboard = []
    current_row = []
    
    for button in buttons:
        current_row.append(
            InlineKeyboardButton(
                text=button['text'],
                callback_data=button.get('callback_data'),
                url=button.get('url')
            )
        )
        
        if rows and len(current_row) >= rows:
            keyboard.append(current_row)
            current_row = []
    
    if current_row:
        keyboard.append(current_row)
    
    return InlineKeyboardMarkup(keyboard)

def get_confirmation_keyboard():
    """Get generic confirmation keyboard"""
    keyboard = [
        [
            InlineKeyboardButton("✅ Yes", callback_data="confirm_yes"),
            InlineKeyboardButton("❌ No", callback_data="confirm_no")
        ]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_cancel_keyboard():
    """Get cancel button only"""
    keyboard = [
        [InlineKeyboardButton("❌ Cancel", callback_data="cancel")]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_pagination_keyboard(current_page: int, total_pages: int, prefix: str):
    """Get pagination keyboard"""
    keyboard = []
    
    if total_pages > 1:
        row = []
        if current_page > 1:
            row.append(InlineKeyboardButton("◀️ Prev", callback_data=f"{prefix}_page_{current_page-1}"))
        
        row.append(InlineKeyboardButton(f"{current_page}/{total_pages}", callback_data="noop"))
        
        if current_page < total_pages:
            row.append(InlineKeyboardButton("Next ▶️", callback_data=f"{prefix}_page_{current_page+1}"))
        
        keyboard.append(row)
    
    keyboard.append([InlineKeyboardButton("🔙 Back", callback_data=f"{prefix}_back")])
    
    return InlineKeyboardMarkup(keyboard)