# backend/bot_core/keyboards/main_menu.py
from telegram import InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes

def get_main_menu_keyboard():
    """Get main menu keyboard"""
    keyboard = [
        [
            InlineKeyboardButton("🛒 Buy", callback_data="menu_buy"),
            InlineKeyboardButton("📋 Plans", callback_data="menu_plans")
        ],
        [
            InlineKeyboardButton("🔑 My Keys", callback_data="menu_my_keys"),
            InlineKeyboardButton("📱 Download", callback_data="menu_download")
        ],
        [
            InlineKeyboardButton("❓ Help", callback_data="menu_help"),
            InlineKeyboardButton("📧 Contact", callback_data="menu_contact")
        ]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_back_button():
    """Get back button only"""
    keyboard = [
        [InlineKeyboardButton("🔙 Back to Menu", callback_data="btn_back_to_menu")]
    ]
    return InlineKeyboardMarkup(keyboard)