# backend/bot_core/keyboards/plans_keyboard.py
from telegram import InlineKeyboardButton, InlineKeyboardMarkup

def get_plans_keyboard():
    """Get plans selection keyboard"""
    keyboard = [
        [
            InlineKeyboardButton("1 Day - ₹100", callback_data="plan_1d"),
            InlineKeyboardButton("3 Days - ₹250", callback_data="plan_3d")
        ],
        [
            InlineKeyboardButton("7 Days - ₹350", callback_data="plan_7d"),
            InlineKeyboardButton("30 Days - ₹600", callback_data="plan_30d")
        ],
        [
            InlineKeyboardButton("60 Days - ₹800", callback_data="plan_60d")
        ],
        [
            InlineKeyboardButton("🔙 Back to Menu", callback_data="btn_back_to_menu")
        ]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_purchase_confirmation_keyboard():
    """Get purchase confirmation keyboard"""
    keyboard = [
        [
            InlineKeyboardButton("✅ Confirm", callback_data="confirm_yes"),
            InlineKeyboardButton("❌ Cancel", callback_data="confirm_no")
        ]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_payment_keyboard(payment_link: str):
    """Get payment keyboard with payment link"""
    keyboard = [
        [InlineKeyboardButton("💳 Pay Now", url=payment_link)],
        [InlineKeyboardButton("✅ I've Paid", callback_data="check_payment")],
        [InlineKeyboardButton("❌ Cancel", callback_data="cancel")]
    ]
    return InlineKeyboardMarkup(keyboard)