# backend/owner_panel/schemas/owner_schema.py
from pydantic import BaseModel, Field, validator
from typing import Optional, List, Dict, Any
from datetime import datetime

class OwnerProfileResponse(BaseModel):
    """Schema for owner profile response"""
    id: int
    telegram_id: int
    username: str
    first_name: Optional[str]
    last_name: Optional[str]
    email: Optional[str]
    two_factor_enabled: bool
    language: str
    created_at: str
    last_login: Optional[str]
    
    class Config:
        from_attributes = True

class OwnerUpdate(BaseModel):
    """Schema for updating owner profile"""
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    email: Optional[str] = None
    language: Optional[str] = None

class RechargePlanResponse(BaseModel):
    """Schema for recharge plan response"""
    id: int
    name: str
    duration_days: int
    price: float
    key_limit: int
    description: Optional[str]
    features: List[str]
    
    class Config:
        from_attributes = True

class RechargeRequest(BaseModel):
    """Schema for recharge request"""
    plan_type: str = Field(..., description="monthly, 6months, yearly")
    payment_method: Optional[str] = Field("manual")
    
    @validator('plan_type')
    def validate_plan_type(cls, v):
        allowed = ['monthly', '6months', 'yearly']
        if v not in allowed:
            raise ValueError(f"Plan type must be one of {allowed}")
        return v

class SystemSettingsResponse(BaseModel):
    """Schema for system settings response"""
    settings: Dict[str, Any]

class SystemSettingsUpdate(BaseModel):
    """Schema for updating system settings"""
    settings: Dict[str, Any]