# backend/shared/constants/errors.py
class ErrorMessages:
    """Error messages for the application"""
    
    # Authentication errors
    AUTH_INVALID_CREDENTIALS = "Invalid username or password"
    AUTH_TOKEN_EXPIRED = "Token has expired"
    AUTH_TOKEN_INVALID = "Invalid token"
    AUTH_NOT_AUTHENTICATED = "Not authenticated"
    AUTH_INSUFFICIENT_PERMISSIONS = "Insufficient permissions"
    
    # User errors
    USER_NOT_FOUND = "User not found"
    USER_ALREADY_EXISTS = "User already exists"
    USER_BLOCKED = "User is blocked"
    USER_INACTIVE = "User account is inactive"
    
    # Admin errors
    ADMIN_NOT_FOUND = "Admin not found"
    ADMIN_ALREADY_EXISTS = "Admin already exists"
    ADMIN_BLOCKED = "Admin is blocked"
    ADMIN_EXPIRED = "Admin panel has expired"
    
    # Key errors
    KEY_NOT_FOUND = "Key not found"
    KEY_INVALID = "Invalid key format"
    KEY_EXPIRED = "Key has expired"
    KEY_USED = "Key has already been used"
    KEY_BLOCKED = "Key is blocked"
    KEY_UNAVAILABLE = "No keys available"
    KEY_GENERATION_FAILED = "Key generation failed"
    
    # Payment errors
    PAYMENT_FAILED = "Payment failed"
    PAYMENT_PENDING = "Payment is pending"
    PAYMENT_NOT_FOUND = "Payment not found"
    REFUND_FAILED = "Refund failed"
    INVALID_AMOUNT = "Invalid amount"
    
    # Broadcast errors
    BROADCAST_FAILED = "Broadcast failed"
    BROADCAST_NOT_FOUND = "Broadcast not found"
    BROADCAST_CANCELLED = "Broadcast cancelled"
    
    # Validation errors
    VALIDATION_ERROR = "Validation error"
    INVALID_INPUT = "Invalid input"
    MISSING_FIELD = "Missing required field"
    INVALID_FORMAT = "Invalid format"
    
    # Database errors
    DATABASE_ERROR = "Database error"
    CONNECTION_ERROR = "Connection error"
    DUPLICATE_ENTRY = "Duplicate entry"
    
    # File errors
    FILE_TOO_LARGE = "File too large"
    INVALID_FILE_TYPE = "Invalid file type"
    FILE_UPLOAD_FAILED = "File upload failed"
    
    # Server errors
    SERVER_ERROR = "Internal server error"
    SERVICE_UNAVAILABLE = "Service unavailable"
    RATE_LIMIT_EXCEEDED = "Rate limit exceeded"
    
    # Recharge errors
    RECHARGE_FAILED = "Recharge failed"
    INVALID_PLAN = "Invalid recharge plan"
    PLAN_NOT_FOUND = "Plan not found"
    
    # Activity errors
    ACTIVITY_NOT_FOUND = "Activity not found"
    INVALID_DATE_RANGE = "Invalid date range"