# backend/shared/constants/messages.py
class BotMessages:
    """Bot response messages"""
    
    # Welcome messages
    WELCOME = """
🎮 **Welcome to Gaming Keys Bot!**

What would you like to do?
🛒 /buy - Purchase Keys
📋 /plans - View All Plans
🔑 /my_keys - Your Active Keys
📱 /download - Download App
❓ /help - Get Help
"""
    
    # Plans messages
    PLANS_HEADER = """
📋 **AVAILABLE PLANS**

Choose a plan to purchase:
"""
    
    PLAN_DETAIL = """
🚀 **{duration}** - ₹{price}
   {description}
"""
    
    # Purchase messages
    CONFIRM_PURCHASE = """
🛒 **Confirm Purchase**

Plan: {duration}
Price: ₹{price}

Proceed with payment?
"""
    
    PAYMENT_LINK = """
💳 **Payment Link Generated**

Click below to complete payment:
{payment_link}

Or scan QR code:
[QR Code]

Your key will be delivered automatically after payment.
"""
    
    PAYMENT_SUCCESS = """
✅ **PAYMENT SUCCESSFUL!**

Your {duration} Gaming Key:
🔑 `{key}`

Valid until: {expiry_date}
Days remaining: {days}

What's next?
• Download app: /download
• View all keys: /my_keys
• Extend later: /extend

Thank you for your purchase! 🎮
"""
    
    PAYMENT_FAILED = """
❌ **Payment Failed**

Your payment could not be processed.
Please try again or use a different payment method.

Reason: {reason}
"""
    
    # Keys messages
    NO_KEYS = """
🔑 **Your Keys**

You don't have any active keys yet.
Use /buy to purchase your first key!
"""
    
    KEYS_HEADER = """
🔑 **YOUR ACTIVE KEYS**
"""
    
    KEY_DETAIL = """
**{index}) Key:** `{key}`
   **Plan:** {duration}
   **Purchased:** {purchase_date}
   **Expires:** {expiry_date}
   **Days Left:** {days_left}
   **Status:** {status}
"""
    
    # Download messages
    DOWNLOAD_PROMPT = """
📱 **Download App**

Your download link is ready:
{download_link}

⚠️ Link expires in 24 hours
"""
    
    NO_ACTIVE_KEY = """
❌ **Download Restricted**

You need an active key to download the app.
Purchase a key first: /buy
"""
    
    # Extend messages
    EXTEND_PROMPT = """
⏰ **Extend Key**

Select key to extend:
"""
    
    EXTEND_DURATIONS = """
Select extension duration:
"""
    
    EXTEND_SUCCESS = """
✅ **Key Extended Successfully!**

Key: `{key}`
New Expiry: {new_expiry}
Days Added: {days}
"""
    
    # Help messages
    HELP = """
❓ **HELP & SUPPORT**

**Available Commands:**
/start - Main menu
/plans - View pricing
/buy - Purchase keys
/my_keys - Your keys
/download - Download app
/extend - Extend key
/contact - Contact support

**Need Help?**
For issues: support@bot.com
Response time: < 2 hours
"""
    
    CONTACT_PROMPT = """
📧 **Contact Support**

Please type your message after /contact
Example: /contact I need help with my key
"""
    
    CONTACT_RECEIVED = """
✅ **Message Sent!**

Support team will respond within 2 hours.
Thank you for contacting us!
"""
    
    # Error messages
    ACTION_CANCELLED = "❌ Action cancelled."
    USER_BLOCKED = "⛔ You have been blocked from using this bot."
    INVALID_KEY = "❌ Invalid key format."
    KEY_EXPIRED = "⚠️ This key has expired."
    KEY_USED = "⚠️ This key has already been used."
    KEY_BLOCKED = "⛔ This key has been blocked."
    INVALID_DURATION = "❌ Invalid duration selected."
    PURCHASE_CANCELLED = "❌ Purchase cancelled."
    
    # Broadcast messages
    BROADCAST_PREFIX = "📢 **ANNOUNCEMENT**\n\n"