# User Guide - Telegram Multi-Tenant Bot System

## Table of Contents
1. [Introduction](#introduction)
2. [Getting Started](#getting-started)
3. [Owner Guide](#owner-guide)
4. [Admin Guide](#admin-guide)
5. [User Guide](#user-guide)
6. [FAQ](#faq)
7. [Troubleshooting](#troubleshooting)

## Introduction

The Telegram Multi-Tenant Bot System is a comprehensive platform for managing multiple Telegram bots with complete activity tracking, key management, payment integration, and more.

### System Roles

- **Owner**: Super admin with full system control
- **Admin**: Manages individual bots
- **User**: End users who interact with bots

## Getting Started

### Accessing the System

1. **Owner Dashboard**: `https://your-domain.com/owner`
2. **Admin Dashboard**: `https://your-domain.com/admin`

### Default Credentials

- **Owner**: username: `owner`, password: `ChangeMe123!`
- **Admin**: username: `admin`, password: `Admin123!`

**Important**: Change these passwords immediately after first login!

## Owner Guide

### Dashboard Overview

The owner dashboard provides:
- System-wide statistics
- Real-time activity feed
- Server health monitoring
- Revenue analytics

### Managing Admins

#### Add New Admin
1. Navigate to "Admins" section
2. Click "Add Admin"
3. Fill in admin details:
   - Telegram ID
   - Username
   - Bot Name & Token
   - Payment Gateway
   - Server Assignment
4. Click "Create"

#### Recharge Admin
1. Go to "Recharge" section
2. Select admin from list
3. Choose recharge plan
4. Complete payment
5. Admin panel will be activated

### Monitoring Activities

The Activity section shows:
- All admin activities across bots
- All user activities across bots
- Filterable by date, type, and bot
- Exportable reports

### System Settings

Configure:
- Global system parameters
- Alert thresholds
- Payment gateways
- Backup settings
- Security options

## Admin Guide

### Bot Configuration

#### Key Management

**Stored Keys** (CSV Upload):
1. Prepare CSV file with format: `KEY,DURATION,PRICE`
2. Go to "Keys" → "Upload Stored Keys"
3. Upload file
4. System validates and imports keys

**Generated Keys**:
1. Set key pattern (e.g., `GAME-{YYYYMMDD}-{RANDOM8}`)
2. Enable auto-generation
3. Set low stock alerts

#### Payment Gateway Setup

1. Go to "Settings" → "Payment Gateway"
2. Select gateway (Razorpay/PhonePe/Paytm/Stripe)
3. Enter API credentials
4. Set currency
5. Test connection

#### APK Management

1. Go to "APK" section
2. Upload new APK file
3. Set version name and code
4. Add release notes
5. Activate version
6. Track downloads

### User Management

#### View Users
- See all users with Telegram IDs
- View user details and activity
- Export user list to CSV

#### User Activity
- Real-time activity feed
- Filter by user, date, activity type
- Export activity logs
- View user journey

### Broadcast System

1. Go to "Broadcast" section
2. Compose message
3. Select target audience:
   - All users
   - Premium users
   - Active users
   - Inactive users
4. Schedule or send immediately
5. View delivery reports

### Analytics

Available analytics:
- User growth and retention
- Revenue by period
- Key sales by duration
- Conversion funnel
- Performance metrics

## User Guide

### Available Commands

| Command | Description |
|---------|-------------|
| `/start` | Welcome and main menu |
| `/plans` | View available plans |
| `/buy` | Purchase keys |
| `/my_keys` | View your keys |
| `/download` | Download APK |
| `/extend` | Extend key validity |
| `/help` | Get help |
| `/contact` | Contact support |

### Purchasing Keys

1. Send `/buy` command
2. Select plan duration
3. Confirm purchase
4. Complete payment
5. Receive key instantly

### Downloading APK

1. Purchase a key first
2. Send `/download` command
3. Click download link
4. Link expires in 24 hours

### Viewing Keys

Send `/my_keys` to see:
- All your active keys
- Expiry dates
- Days remaining
- Extension option

### Getting Help

- Use `/help` for command list
- Use `/contact` to message support
- Email: support@yourbot.com

## FAQ

**Q: How do I reset my password?**
A: Contact the system owner for password reset.

**Q: What payment methods are accepted?**
A: UPI, Credit/Debit Cards, NetBanking, and various wallets.

**Q: How long are keys valid?**
A: Depends on purchased duration (1 day to 60 days).

**Q: Can I extend my key?**
A: Yes, use `/extend` command before expiry.

**Q: What happens when admin panel expires?**
A: Bot goes into maintenance mode until recharge.

## Troubleshooting

### Common Issues

**Bot not responding**
- Check if bot token is valid
- Verify webhook is set correctly
- Check server logs

**Payments not processing**
- Verify API credentials
- Check payment gateway status
- Review webhook configuration

**Keys not delivering**
- Check key inventory
- Verify auto-generation settings
- Review payment confirmation

### Support Contact

For technical support:
- Email: support@yourbot.com
- Telegram: @support_bot
- Response time: < 2 hours