import api from './api';

class AuthService {
  async login(username, password) {
    try {
      const response = await api.post('/auth/login', { username, password });
      
      if (response.data.access_token) {
        localStorage.setItem('access_token', response.data.access_token);
        localStorage.setItem('refresh_token', response.data.refresh_token);
        localStorage.setItem('user_type', response.data.user_type);
        localStorage.setItem('user_id', response.data.user_id);
        localStorage.setItem('username', response.data.username);
      }
      
      return response.data;
    } catch (error) {
      throw error;
    }
  }

  logout() {
    localStorage.clear();
    window.location.href = '/login';
  }

  getCurrentUser() {
    return {
      id: localStorage.getItem('user_id'),
      username: localStorage.getItem('username'),
      type: localStorage.getItem('user_type'),
      token: localStorage.getItem('access_token'),
    };
  }

  isAuthenticated() {
    return !!localStorage.getItem('access_token');
  }

  isAdmin() {
    return localStorage.getItem('user_type') === 'admin';
  }
}

export default new AuthService();