export const formatCurrency = (amount, currency = 'INR') => {
  const symbols = {
    INR: '₹',
    USD: '$',
    EUR: '€',
    GBP: '£',
  };
  const symbol = symbols[currency] || '₹';
  
  if (amount >= 10000000) {
    return `${symbol}${(amount / 10000000).toFixed(2)}Cr`;
  } else if (amount >= 100000) {
    return `${symbol}${(amount / 100000).toFixed(2)}L`;
  } else if (amount >= 1000) {
    return `${symbol}${(amount / 1000).toFixed(2)}K`;
  }
  return `${symbol}${amount.toFixed(2)}`;
};

export const formatDate = (date) => {
  if (!date) return '';
  const d = new Date(date);
  return d.toLocaleDateString('en-IN', {
    day: '2-digit',
    month: 'short',
    year: 'numeric',
    hour: '2-digit',
    minute: '2-digit',
  });
};

export const getStatusColor = (status) => {
  const colors = {
    active: 'success',
    available: 'success',
    sold: 'primary',
    blocked: 'error',
    expired: 'error',
    pending: 'warning',
    success: 'success',
    failed: 'error',
  };
  return colors[status] || 'default';
};

export const truncateKey = (key, visible = 8) => {
  if (!key) return '';
  if (key.length <= visible + 4) return key;
  return `${key.substring(0, visible)}...${key.substring(key.length - 4)}`;
};

export const downloadCSV = (data, filename) => {
  const blob = new Blob([data], { type: 'text/csv' });
  const url = window.URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.href = url;
  a.download = filename;
  a.click();
  window.URL.revokeObjectURL(url);
};

export const getErrorMessage = (error) => {
  if (error.response?.data?.message) {
    return error.response.data.message;
  }
  if (error.message) {
    return error.message;
  }
  return 'An error occurred';
};