# tests/integration/test_api.py
import pytest
from fastapi import status

def test_health_check(client):
    """Test health check endpoint"""
    response = client.get("/health")
    assert response.status_code == status.HTTP_200_OK
    assert response.json()["status"] == "healthy"

def test_owner_login(client, test_owner):
    """Test owner login endpoint"""
    response = client.post(
        "/api/v1/auth/login",
        json={"username": "test_owner", "password": "Test123!"}
    )
    assert response.status_code == status.HTTP_200_OK
    data = response.json()
    assert "access_token" in data
    assert data["user_type"] == "owner"

def test_admin_login(client, test_admin):
    """Test admin login endpoint"""
    response = client.post(
        "/api/v1/auth/login",
        json={"username": "test_admin", "password": "Admin123!"}
    )
    assert response.status_code == status.HTTP_200_OK
    data = response.json()
    assert "access_token" in data
    assert data["user_type"] == "admin"

def test_owner_dashboard(client, owner_token):
    """Test owner dashboard endpoint"""
    response = client.get(
        "/api/v1/owner/dashboard",
        headers={"Authorization": f"Bearer {owner_token}"}
    )
    assert response.status_code == status.HTTP_200_OK
    data = response.json()
    assert "totalAdmins" in data

def test_get_admins(client, owner_token):
    """Test get admins endpoint"""
    response = client.get(
        "/api/v1/owner/admins",
        headers={"Authorization": f"Bearer {owner_token}"}
    )
    assert response.status_code == status.HTTP_200_OK
    data = response.json()
    assert "admins" in data

def test_unauthorized_access(client):
    """Test unauthorized access"""
    response = client.get("/api/v1/owner/dashboard")
    assert response.status_code == status.HTTP_401_UNAUTHORIZED