# tests/unit/test_auth.py
import pytest
from fastapi import HTTPException

from backend.core.security import auth_manager, security
from backend.core.models import Owner, Admin

def test_password_hashing():
    """Test password hashing and verification"""
    password = "TestPassword123!"
    hashed = security.get_password_hash(password)
    
    assert hashed != password
    assert security.verify_password(password, hashed)
    assert not security.verify_password("WrongPassword", hashed)

def test_token_creation():
    """Test JWT token creation"""
    data = {"sub": "1", "user_type": "owner"}
    token = security.create_access_token(data)
    
    assert token is not None
    assert isinstance(token, str)
    
    decoded = security.decode_token(token)
    assert decoded["sub"] == "1"
    assert decoded["user_type"] == "owner"

def test_owner_authentication(test_db, test_owner):
    """Test owner authentication"""
    # Correct credentials
    owner = auth_manager.authenticate_owner("test_owner", "Test123!", test_db)
    assert owner is not None
    assert owner.id == test_owner.id
    
    # Wrong password
    owner = auth_manager.authenticate_owner("test_owner", "WrongPass", test_db)
    assert owner is None
    
    # Wrong username
    owner = auth_manager.authenticate_owner("wrong_user", "Test123!", test_db)
    assert owner is None

def test_admin_authentication(test_db, test_admin):
    """Test admin authentication"""
    # Correct credentials
    admin = auth_manager.authenticate_admin("test_admin", "Admin123!", test_db)
    assert admin is not None
    assert admin.id == test_admin.id
    
    # Wrong password
    admin = auth_manager.authenticate_admin("test_admin", "WrongPass", test_db)
    assert admin is None