# tests/unit/test_models.py
import pytest
from datetime import datetime, timedelta

from backend.core.models import Owner, Admin, RechargePlan

def test_owner_creation(test_db):
    """Test owner model creation"""
    owner = Owner(
        telegram_id=123456789,
        username="test_owner",
        first_name="Test",
        last_name="Owner",
        email="test@example.com",
        password_hash="hashed_password"
    )
    
    test_db.add(owner)
    test_db.commit()
    
    assert owner.id is not None
    assert owner.telegram_id == 123456789
    assert owner.username == "test_owner"
    assert owner.created_at is not None

def test_admin_creation(test_db, test_owner):
    """Test admin model creation"""
    admin = Admin(
        owner_id=test_owner.id,
        telegram_id=987654321,
        admin_username="test_admin",
        password_hash="hashed_password",
        reserve_id="TEST-001",
        bot_name="Test Bot",
        bot_username="@test_bot",
        bot_token="123456:token",
        status="active"
    )
    
    test_db.add(admin)
    test_db.commit()
    
    assert admin.id is not None
    assert admin.owner_id == test_owner.id
    assert admin.reserve_id == "TEST-001"
    assert admin.status == "active"

def test_recharge_plan_creation(test_db):
    """Test recharge plan model"""
    plan = RechargePlan(
        plan_name="Monthly",
        duration_days=30,
        price=200,
        key_limit=1000,
        description="Monthly plan"
    )
    
    test_db.add(plan)
    test_db.commit()
    
    assert plan.id is not None
    assert plan.plan_name == "Monthly"
    assert plan.price == 200